<%--
MosP - Mind Open Source Project         http://www.mosp.jp/
Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.vo.ApprovalListVo"
import = "jp.mosp.common.common.BaseVo"
%><%
ApprovalListVo vo = (ApprovalListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryAttendance = vo.getEscAryAttendance();
String[] aryLabel = vo.getEscAryLabel();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= vo.getSubTitle(vo.SUB_TITLE, vo.getCmdMenuButton(), vo.getCmdListButton(), vo.getNamListButton()) %>
<div class="Body" id="approvalList">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscSelectKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscSelectKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscSelectSectionName() %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, '<%= vo.getCmdListButton() %>')"><%= vo.getNamListButton() %></button>
				</td>
			</tr>
		</table>
	</div>
	<div class="YearMonth">
		<table>
			<tr>
				<td class="CheckButtonTd">
					<button type="button" onclick="doAllBoxChecked(true)"><%= CommonConst.NAM_SELECT_CHECK_ALL %></button>
					<button type="button" onclick="doAllBoxChecked(false)"><%= CommonConst.NAM_RELEASE_CHECK_ALL %></button>
				</td>
				<td class="RegistButtonTd">
					<button type="button" id="btnRegist1" onclick="submitForm(document.form)"><%= CommonConst.NAM_1ST_APPROVED %></button>
					<button type="button" id="btnRegist2" onclick="submitForm(document.form)"><%= CommonConst.NAM_2ND_APPROVED %></button>
				</td>
				<td class="YearMonthTd">
					<select id="<%= ApprovalListVo.PRM_PLT_YEAR %>" name="<%= ApprovalListVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear()) %>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= ApprovalListVo.PRM_PLT_MONTH %>" name="<%= ApprovalListVo.PRM_PLT_MONTH %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth()) %>
					</select><%= CommonConst.NAM_MONTH %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K2112')"><%= CommonConst.NAM_RE_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"			>									</th>
					<th id="thChkBox"			><%= CommonConst.NAM_APPROVED %>	</th>
					<th id="thDay"				><%= CommonConst.NAM_DAY %>			</th>
					<th id="thDayOfWeek"		><%= CommonConst.NAM_DAY_OF_WEEK %>	</th>
					<th id="thAttendanceType"	><%= CommonConst.NAM_WORKING_TYPE %></th>
					
					<th class="TimeTh" ><%= CommonConst.NAM_START_TIME %>		</th>
					<th class="TimeTh" ><%= CommonConst.NAM_QUIT_TIME %>		</th>
					<th class="TimeTh" ><%= CommonConst.NAM_PAYMENT_HOURS_ABB %></th>
					<th class="TimeTh" ><%= CommonConst.NAM_INTERVAL_TIME %>	</th>
					<th class="TimeTh" ><%= CommonConst.NAM_ARRIVE_LATE %>		</th>
					<th class="TimeTh" ><%= CommonConst.NAM_LEAVE_EARLY %>		</th>
					<th class="TimeTh" ><%= CommonConst.NAM_OVERTIME %>			</th>
					<th class="TimeTh" ><%= CommonConst.NAM_WORK_ON_HOLIDAY %>	</th>
					<th class="TimeTh" ><%= CommonConst.NAM_LATE_NIGHT %>		</th>
					
					<th class="AppTh" >		<%= CommonConst.NAM_APPROVAL_STATE %>	</th>
					<th class="ApproverTh" ><%= CommonConst.NAM_APPROVER %>			</th>

					<th class="RemarksTh" >	<%= CommonConst.NAM_REMARKS %>			</th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = 0; i < aryAttendance.length; i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'K2116', '<%= vo.getSelectKCode() %>', '<%= aryAttendance[i][0] %>')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td class="ButtonTd">
						<%= ApprovalListVo.getVariableCheckBox(ApprovalListVo.PRM_CKB_DATE, ApprovalListVo.PRM_CKB_DATE, aryAttendance[i][0], BaseVo.escapeHTML(aryAttendance[i][14])) %>
					</td>
					<td id="tdDay"				><%= BaseVo.escapeHTML(aryAttendance[i][1 ]) %></td>
					<td id="tdDayOfWeek"		><%= BaseVo.escapeHTML(aryAttendance[i][2 ]) %></td>
					<td id="tdAttendanceType"	><%= BaseVo.escapeHTML(aryAttendance[i][3 ]) %>
					</td>
					
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][4 ]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][5 ]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][6 ]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][7 ]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][8 ]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][9 ]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][10]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][11]) %></td>
					<td class="TimeTd"  ><%= BaseVo.escapeHTML(aryAttendance[i][12]) %></td>
					
					<td class="AppTd"	><%= BaseVo.escapeHTML(aryAttendance[i][13]) %></td>
					<td class="AppTd"	><%= BaseVo.escapeHTML(aryAttendance[i][15]) %></td>

					<td class="RemarksTd"><%= BaseVo.escapeHTML(aryAttendance[i][16]) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
		<table id="sum">
			<tr>
				<td class="sumLbl">
					<%= aryLabel[0] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[1] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[2] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[3] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[4] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[5] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[6] %>
				</td>
				<td  class="sumLbl">&nbsp;</td>				
				<td  class="sumLbl">&nbsp;</td>
				<td  class="sumLbl">
					<%= aryLabel[16] %>			
				</td>		
			</tr>
			<tr>
				<td>
					<%= vo.getEscWorkTimes() %>
				</td>
				<td>
					<%= vo.getEscBreakTimes() %>
				</td>
				<td>
					<%= vo.getEscLateTimes() %>
				</td>
				<td>
					<%= vo.getEscLeaveEarlyTimes() %>
				</td>
				<td>
					<%= vo.getEscOverTimes() %>
				</td>
				<td>
					<%= vo.getEscWorkOnHoliday() %>
				</td>
				<td>
					<%= vo.getEscLateNightTimes() %>
				</td>
				<td >&nbsp;</td>				
				<td >&nbsp;</td>
				<td >
					<%= vo.getEscAllowance() %>				
				</td>
			</tr>
			<tr>	
				<td class="sumLbl">
					<%= aryLabel[7] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[8] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[9] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[10] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[11] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[12] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[13] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[14] %>
				</td>
				<td class="sumLbl">
					<%= aryLabel[15] %>
				</td>
				<td class="sumLbl">&nbsp;</td>
			</tr>
			<tr>	
				<td>
					<%= vo.getEscPresence() %>
				</td>
				<td >
					<%= vo.getEscPaidHoliday() %>
				</td>
				<td >
					<%= vo.getEscParticularHoliday() %>
				</td>
				<td >
					<%= vo.getEscAbsence() %>
				</td>
				<td >
					<%= vo.getEscSick() %>
				</td>
				<td >
					<%= vo.getEscCompensationLeave() %>
				</td>
				<td >
					<%= vo.getEscTransfer() %>
				</td>
				<td >
					<%= vo.getEscOther() %>
				</td>
				<td >
					<%= vo.getEscLeaveAndLate() %>
				</td>
				<td >&nbsp;</td>
			</tr>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
